<?php
// === KONFIGURACJA - WYPEŁNIJ PONIŻSZE DANE ===

// 1. Client ID z Twojej aplikacji w Zoho Developer Console.
$clientID = "1000.1FGCK71I62EK81LM11GWPJSEHON2GO";

// 2. Client Secret z Twojej aplikacji.
$clientSecret = "df0d29912a05dc90af999b821374dad372871f1e41";

// 3. Adres URL, pod którym znajduje się ten skrypt.
//    MUSI być DOKŁADNIE taki sam jak "Authorized Redirect URI" w konsoli Zoho!
$redirectURI = "https://profitbot.profitway.pl/zoho_auth.php"; // <<< ZMIEŃ NA WŁAŚCIWY ADRES URL!

// 4. Scopes (uprawnienia), których potrzebujesz. Zostały skopiowane z Twojego zapytania.
$scopes = "ZohoCRM.settings.emails.READ,ZohoCRM.modules.ALL,ZohoCRM.modules.entity_scores.READ,ZohoCRM.users.ALL,ZohoCRM.send_mail.all.CREATE,ZohoCRM.bulk.ALL,ZohoCRM.bulk.backup.ALL,ZohoCRM.bulk.backup.CREATE,ZohoCRM.bulk.backup.READ,ZohoCRM.bulk.backup.UPDATE,ZohoCRM.features.READ,ZohoCRM.coql.READ";

// 5. Domena Twojego konta Zoho. Zmień na .eu, .in, .com.au itd., jeśli to konieczne.
$zohoDomain = "eu"; // Dostępne: com, eu, in, com.au, cn

// --- Koniec konfiguracji ---

$accountsURL = "https://accounts.zoho.{$zohoDomain}";

// Sprawdzamy, czy w adresie URL znajduje się parametr 'code' zwrócony przez Zoho.
if (isset($_GET['code'])) {
    // Etap 2: Mamy kod, wymieniamy go na tokeny.
    echo "<h1>Krok 2: Wymiana kodu na Refresh Token</h1>";
    $authCode = $_GET['code'];
    
    $tokenURL = $accountsURL . "/oauth/v2/token";
    
    $postData = [
        'grant_type' => 'authorization_code',
        'client_id' => $clientID,
        'client_secret' => $clientSecret,
        'redirect_uri' => $redirectURI,
        'code' => $authCode,
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $tokenURL);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        echo "<h2>Błąd cURL!</h2>";
        echo "<p>Wystąpił błąd podczas komunikacji z serwerem Zoho:</p>";
        echo "<pre>" . htmlspecialchars($error) . "</pre>";
        die();
    }
    
    $result = json_decode($response, true);
    
    echo "<h2>Odpowiedź z serwera Zoho:</h2>";
    echo "<pre style='background-color:#f0f0f0; padding:15px; border:1px solid #ccc; white-space: pre-wrap; word-wrap: break-word;'>";
    print_r($result);
    echo "</pre>";
    
    if (isset($result['refresh_token'])) {
        echo "<h1>UDAŁO SIĘ!</h1>";
        echo "<p>Poniżej znajduje się Twój <strong>Refresh Token</strong>. Skopiuj go i zapisz w bezpiecznym miejscu.</p>";
        echo "<p style='font-size:1.2em; background-color: #dff0d8; padding: 20px; border: 1px solid #3c763d; color: #3c763d; white-space: pre-wrap; word-wrap: break-word;'>";
        echo "<strong>" . htmlspecialchars($result['refresh_token']) . "</strong>";
        echo "</p>";
    } elseif (isset($result['error'])) {
        echo "<h1 style='color:red;'>Błąd!</h1>";
        echo "<p>Zoho zwróciło błąd. Najczęstsze przyczyny:</p>";
        echo "<ul>";
        echo "<li>Adres w zmiennej <strong>\$redirectURI</strong> nie zgadza się z adresem skonfigurowanym w Developer Console.</li>";
        echo "<li>Kod autoryzacyjny wygasł (jest ważny tylko przez chwilę). Spróbuj ponownie od kroku 1.</li>";
        echo "<li>Nieprawidłowe Client ID lub Client Secret.</li>";
        echo "</ul>";
    }
    
} else {
    // Etap 1: Generowanie linku autoryzacyjnego.
    
    $authURLParams = [
        'response_type' => 'code',
        'client_id' => $clientID,
        'scope' => $scopes,
        'redirect_uri' => $redirectURI,
        'access_type' => 'offline', // Kluczowe dla otrzymania refresh_token!
        'prompt' => 'consent' // Wymusza ponowne pokazanie ekranu zgody, przydatne przy zmianie scope'ów.
    ];
    
    $authURL = $accountsURL . "/oauth/v2/auth?" . http_build_query($authURLParams);
    
    echo "<h1>Krok 1: Uzyskanie kodu autoryzacyjnego</h1>";
    echo "<p>Witaj w procesie generowania Zoho Refresh Token.</p>";
    echo "<p>Upewnij się, że adres <strong>" . htmlspecialchars($redirectURI) . "</strong> jest dodany jako 'Authorized Redirect URI' w Twojej aplikacji w konsoli Zoho.</p>";
    echo "<p>Kliknij poniższy link, aby zalogować się do Zoho i autoryzować aplikację:</p>";
    echo "<a href='" . htmlspecialchars($authURL) . "' style='display:inline-block; padding:15px 25px; background-color:#007bff; color:white; text-decoration:none; font-size:1.2em; border-radius:5px;'>Autoryzuj aplikację w Zoho</a>";
}

?>