<?php

// Ustawienie nagłówka, aby polskie znaki wyświetlały się poprawnie
header('Content-Type: text/html; charset=utf-8');

// === Konfiguracja ===
$rssUrl = 'https://wiadomosci.gazeta.pl/pub/rss/wiadomosci.xml';
$displayInterval = 6; // NOWOŚĆ: Ustawiamy, co który news ma być wyświetlany

echo "<h1>Przegląd wiadomości z Gazeta.pl (co {$displayInterval} news)</h1>";

// 1. Inicjalizacja sesji cURL
$ch = curl_init();

// 2. Ustawienie opcji cURL
curl_setopt($ch, CURLOPT_URL, $rssUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

// 3. Wykonanie zapytania
$xmlData = curl_exec($ch);
$curlError = curl_error($ch);

// 4. Zamknięcie sesji cURL
curl_close($ch);

// 5. Przetwarzanie wyniku
if ($curlError) {
    echo "<p><strong>Wystąpił błąd cURL:</strong> " . htmlspecialchars($curlError) . "</p>";
} elseif ($xmlData === false) {
    echo "<p><strong>Wystąpił błąd:</strong> Nie otrzymano żadnych danych z serwera Gazety.</p>";
} else {
    $rss = simplexml_load_string($xmlData);

    if ($rss === false) {
        echo "<p><strong>Wystąpił błąd:</strong> Pobrane dane nie są poprawnym plikiem XML.</p>";
    } else {
        echo "<ul>";

        // Inicjalizujemy licznik, aby śledzić pozycję każdego newsa
        $itemCount = 0;

        foreach ($rss->channel->item as $item) {
            // Zwiększamy licznik dla każdego elementu w pętli
            $itemCount++;

            // NOWOŚĆ: Sprawdzamy, czy numer porządkowy newsa NIE jest podzielny przez 5.
            // Operator % (modulo) zwraca resztę z dzielenia.
            // Jeśli reszta jest inna niż 0, to nie jest to 5-ty, 10-ty, 15-ty... news.
            if ($itemCount % $displayInterval !== 0) {
                continue; // Jeśli warunek jest spełniony, pomiń resztę kodu i przejdź do następnego newsa
            }
            
            // Poniższy kod wykona się tylko dla 5-tego, 10-tego, 15-tego itd. newsa
            $title = htmlspecialchars($item->title);
            $link = htmlspecialchars($item->link);
            $description = htmlspecialchars(trim(strip_tags($item->description)));
            $pubDate = date('Y-m-d H:i:s', strtotime($item->pubDate));

            echo "<li style='margin-bottom: 20px;'>";
            echo "<h3><a href='{$link}' target='_blank'>{$title}</a></h3>";
            echo "<p><small>Opublikowano: {$pubDate}</small></p>";
            echo "<p>{$description}</p>";
            echo "</li>";
        }
        echo "</ul>";
    }
}

?>