<?php
// Plik: pb_webhook.php
require_once __DIR__ . '/vendor/autoload.php';
use Dotenv\Dotenv;

$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

if (($_SERVER['HTTP_X_API_KEY'] ?? '') !== $_ENV['p']) {
    http_response_code(401);
    die('Unauthorized');
}

$payload = file_get_contents('php://input');

if (empty($payload)) {
    http_response_code(400);
    die('Bad Request: Empty payload');
}

$taskFileName = 'pb_' . date('Ymd-His') . '_' . uniqid() . '.json';
$filePath = __DIR__ . '/queue/' . $taskFileName;

if (file_put_contents($filePath, $payload)) {
    http_response_code(200);
    echo json_encode(['status' => 'ok', 'message' => 'Task queued.']);
} else {
    http_response_code(500);
    error_log("CRITICAL: Failed to write to queue directory!", 0);
    echo json_encode(['status' => 'error', 'message' => 'Failed to queue task.']);
}