<?php
// Plik: pb_bootstrap.php

// Autoloader Composera
require_once __DIR__ . '/vendor/autoload.php';

use App\Api\GptClient;
use App\Api\ZohoApiClient;
use App\Util\TokenManager;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Dotenv\Dotenv;

// Ładowanie zmiennych środowiskowych z pliku .env
$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

// Konfiguracja Loggera
$log = new Logger('ProfitBOT');

// Handler #1: Zawsze zapisuj logi do pliku
$log->pushHandler(new StreamHandler(__DIR__ . '/logs/profit_bot.log', Logger::INFO));

// Handler #2: Jeśli skrypt jest uruchamiany z konsoli (CLI), wysyłaj logi także na standardowe wyjście (do konsoli)
if (php_sapi_name() === 'cli') {
    $log->pushHandler(new StreamHandler('php://stdout', Logger::INFO));
}

// Inicjalizacja kluczowych komponentów aplikacji
$tokenManager = new TokenManager($log);
$zohoApiClient = new ZohoApiClient($log, $tokenManager);
$gptClient = new GptClient($log, $_ENV['OPENAI_API_KEY']);

// Zwracamy tablicę z gotowymi komponentami
return [$zohoApiClient, $log, $gptClient];